<?php
header('Content-Type: application/json'); // Tell JS this is JSON

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $mobileno   = isset($_POST['mobileno']) ? trim($_POST['mobileno']) : '';  
    $otp        = isset($_POST['otp']) ? trim($_POST['otp']) : '';      

    // Example OTP for testing
    $otplist = [    8139779242  =>  "123456",
                    8639779245  =>  "123456"
                ];      
    // ---------------------------------------------------------
    // Mobileno found: Array key exists or not Ex: 8139779242 
    // ---------------------------------------------------------
    if(array_key_exists($mobileno,$otplist)){
        // -----------------------------------------
        // OTP matches or not ie. 123456 == 123456
        // -----------------------------------------
        if($otplist[$mobileno]==$otp){
            // ------------------------------
            // OTP matched: Success message 
            // -------------------------------
            echo json_encode([
                "status"    => "success",
                "message"   => "✅ OTP verified successfully!"
            ]);
            
        }else{
            // ------------------------------
            // OTP not matched: Invalid OTP 
            // ------------------------------
            echo json_encode([
                "status"    => "error",
                "message"   => "❌ Invalid OTP. Please try again."
            ]);          
        }
    }
    
    else{
        // ---------------------------
        // Mobileno number not found 
        // ---------------------------
        echo json_encode([
                "status"    => "error",
                "message"   => "Mobile no. is not registered with us, please register first and try again..."
        ]);                       
    }
    
} else {
    echo json_encode([
        "status" => "error",
        "message" => "Invalid request method."
    ]);
}
?>