<?php
header("Content-Type: application/json");       

$employeeattend_path = strstr(__DIR__, 'employeeattendance', true) . 'employeeattendance/';
require_once($employeeattend_path."include/config.php");    
require_once(GLOBAL_INCLUDE_PATH ."include/startup_member.php");  
require_once(GLOBAL_INCLUDE_PATH ."include/classes/leaveapplication.class.php");

$leaveapplication = new LeaveApplication();

// Read JSON input
$input = json_decode(file_get_contents("php://input"), true);       

$dates  = $input['dates'] ?? [];
$type   = $input['leave_type'] ?? '';
$reason = $input['leave_reason'] ?? '';       
$userId = $G_userid;  // example; adjust as needed

// Basic validation
if (empty($dates) || empty($type) || empty($reason)) {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request data."
    ]);
    exit;             
}

if(empty($userId)){
    echo json_encode([
        "success" => false,
        "message" => "EmployeeID not found! You might have logged out, please login and try again..."
    ]);
    exit;                  
}

$fromdate   = min($dates);         
$todate     = max($dates);      
 
$employee['employee_id']    = $userId;
$employee['leave_type']     = $type;
$employee['leave_reason']   = $reason;
$employee['from_date']      = $fromdate; // Earliest Date
$employee['to_date']        = $todate;   // Latest Date   
/// --------------------------
/// Default Status = 'pending'
/// --------------------------
/// $employee['status']         = "pending";
/// $employee['applied_on']     = " now() ";      

$leave_applied = $leaveapplication->AddInfo($employee, "leave_applications");

// ------------------
// Final JSON output
// ------------------ 
if($leave_applied === "true"){
    echo json_encode([
        "success"        => true,
        "applied_dates" => $dates,
        "reason"         => $reason
    ]); 
}else if($leave_applied === "false"){
    echo json_encode([
        "success"        => false,
        "applied_dates" => $dates,
        "reason"         => $reason
    ]);                                                                              
}    
