<?php
require_once('include/config.php');
require_once(GLOBAL_INCLUDE_PATH.'include/startup.php');
require_once(GLOBAL_INCLUDE_PATH."mongodb_library/vendor/autoload.php");
require_once(GLOBAL_INCLUDE_PATH."mongodb_library/vendor/mongodb/mongodb/src/functions.php");
require_once(GLOBAL_INCLUDE_PATH."include/classes/mongodb.class.php");
require_once(GLOBAL_INCLUDE_PATH."include/classes/company.class.php");

    ///require_once("include/classes/mongodb.class.php"); 

function getCertificates_intoJSON($companyid='')
{   /*
        This function returns data into Array or Json
    */
    
    $alltable = new AllTables();
    
    $sql="select * from trncompanycertificates where companyid=$companyid";
    
    $data = $alltable->getInfo('',$sql);
    
    return $data;
}

function getMedia_intoJSON($companyid='')
{   /*
        This function returns data into Array or Json
    */
    
    $alltable = new AllTables();
    
    $sql="select * from trnusermedia where companyid=$companyid";
    
    $data = $alltable->getInfo('',$sql);
    
    return $data;
}

function getUsers_intoJSON($companyid='')
{   /*
        This function returns data into Array or Json
    */
    
    $alltable = new AllTables();
    
    $sql="select * from mstusers where companyid=$companyid";
    
    $data = $alltable->getInfo('',$sql);
    
    return $data; 
}


function getCompanyProfiles_intoJSON($companyid='')
{   /*
        This function returns data into Array or Json
    */
    
    $alltable = new AllTables();
    
    $sql="select * from trncompanyprofile where companyid=$companyid";
    
    $data = $alltable->getInfo('',$sql);
    
    return $data;  
}

function getCompanyVideos_intoJSON($companyid='')
{   /*
        This function returns data into Array or Json
    */
    
    $alltable = new AllTables();
    
    $sql="select * from trncompanyvideo where companyid=$companyid";
    
    $data = $alltable->getInfo('',$sql); 
    
    return $data; 
}

function getCompanyAwards_intoJSON($companyid='')
{   /*
        This function returns data into Array or Json
    */
    
    $alltable = new AllTables();
    
    $sql="select * from trncompanyawards where companyid=$companyid";
    
    $data = $alltable->getInfo('',$sql); 
    
    return $data; 
}

function getCompanyExhibition_intoJSON($companyid='')
{   /*
        This function returns data into Array or Json
    */
    
    $alltable = new AllTables();
    
    $sql="select * from trncompanyexhibition where companyid=$companyid";
    
    $data = $alltable->getInfo('',$sql); 
    
    return $data;  
}

function getCompany_intoJSON($companyid='')
{   /*
        This function returns data into Array or Json
    */
    
    $alltable = new AllTables();
    
    
    if($companyid !='')
    {
        $sql="select * from mstcompany where CompanyID=$companyid";    
    }
    else
    {
        $sql="select * from mstcompany limit 200";
        
    }
    
    $data = $alltable->getInfo('',$sql);
    $count = count($data);             
    
    for($i=0;$i<$count;$i++)           
    {
        $companyid = $data[$i]['CompanyID'];
        
        /// Filtering Activities Column for Invalid UTF8 Charcters 
        $data[$i]['Activities'] = filter_invalidCharacters($data[$i]['Activities']);
        
        /// Media Array
        $mediaarray = getMedia_intoJSON($companyid);
        if(!empty($mediaarray))
        {
            $data[$i]['media_array'] = $mediaarray; 
        }
        
        /// Certificate Array
        $allCertificates = getCertificates_intoJSON($companyid);
        if(!empty($allCertificates))
        {
            $data[$i]['certificate_array'] = $allCertificates;
        }
        
        /// Users Array
        $allUsers = getUsers_intoJSON($companyid);
        if(!empty($allUsers))
        {
            $data[$i]['users_array'] = $allUsers;
        }
 
        /// Company profile Array
        $allProfiles = getCompanyProfiles_intoJSON($companyid);
        if(!empty($allProfiles))
        {
            $data[$i]['companyprofile_array'] = $allProfiles;
        }
   
        /// Company video Array
        $allVideos = getCompanyVideos_intoJSON($companyid);
        if(!empty($allVideos))
        {
            $data[$i]['companyvideo_array'] = $allVideos;
        }
        
        ///  Company awards Array
        $allAwards = getCompanyAwards_intoJSON($companyid);
        if(!empty($allAwards))
        {
            $data[$i]['companyawards_array'] = $allAwards;
        }
        
        ///  Company exhibition Array 
        $allExhi = getCompanyExhibition_intoJSON($companyid);
        if(!empty($allExhi))
        {
            $data[$i]['companyexhibition_array'] = $allExhi;
        }
       
    }
                                                                        
    return $data;        
}

function getCompanyProdData($companyid='',$company_objectid='')
{
    $alltable = new AllTables();
    
    if( $companyid !='' )
    {
        $sql="select * from trncompanyprod where CompanyID=$companyid"; 
    }
    else
    {
        $sql="select * from trncompanyprod ";
    }
    
    $data = $alltable->getInfo('',$sql);
    $count = count($data);
    
    for($i=0; $i<$count; $i++)
    {
        $data[$i]['ProductName_mstproduct'] = filter_invalidCharacters($data[$i]['ProductName_mstproduct']);
        $data[$i]['specifications'] = filter_invalidCharacters($data[$i]['specifications']);
        $data[$i]['ProductDesc'] = filter_invalidCharacters($data[$i]['ProductDesc']); 
        
        if( $company_objectid!=null || $company_objectid!='' )
        {
            $data[$i]['CompanyObjectId'] = $company_objectid;
        }
    }
    
    return $data;  
}

function filter_invalidCharacters($datatocheck='')
{
    /* [Checking Invalid UTF8 Charcters] 
        � Rejects:- 1] 2 byte sequences and 
    *               2] Characters above U+10000 (ie. Unicode Char's having more than 4 digits)  
    *  Referred from :-  https://webcollab.sourceforge.io/unicode.html  
    */ 
    $filtered_data = preg_replace( '/[\x00-\x08\x10\x0B\x0C\x0E-\x19\x7F]'.
     
                                    '|(?<=^|[\x00-\x7F])[\x80-\xBF]+'.
                                    
                                    '|([\xC0\xC1]|[\xF0-\xFF])[\x80-\xBF]*'.
                                    
                                    '|[\xC2-\xDF]((?![\x80-\xBF])|[\x80-\xBF]{2,})'.
                                    
                                    '|[\xE0-\xEF](([\x80-\xBF](?![\x80-\xBF]))|(?![\x80-\xBF]{2})|[\x80-\xBF]{3,})/',
                                    
                                    ' ', $datatocheck ); 
    return $filtered_data;
}
               

/**  For insterting Single document use :- [ $clsMongo->mongo_add_docment($activitiesArray[0]); ]  **/      

/*
    $clsMongo = new mongo_dbopenconn();
    $collection = $clsMongo->mongo_dbconnect('polymert_gulfyp','trncompanyprod');   
*/
        /**  To handle memory size error of 128M  **/
            /*
                $limit = ini_get('memory_limit');
                    ini_set('memory_limit', -1); 
            */
                    
                    /*
                        $company  = getCompany_intoJSON();    
                        $companyprod  = getCompanyProdData();
                    */
                    
        /* 
            ini_set('memory_limit', $limit);   
        */

        /**   Inserting Records start **/
        
            ///     $trncompanyprod = $clsMongo->mongo_add_many_document($companyprod);  
            
        /**   Inserting Records end   **/     
        
        
$clsMongo = new mongo_dbopenconn();
$company = new Company();
$company->mongo_dbconnect('sample_database','mstcompany');

$alltable   =   new AllTables();

             $sql   =   "select companyid from mstcompany order by companyid limit 200" ;
            $data   =   $alltable->getInfo('',$sql);
        $rowcount   =   count($data);
        
            for( $i=0; $i<$rowcount; $i++ )
            {
                $companyid = $data[$i]['companyid'];
                
                
                $collection = $clsMongo->mongo_dbconnect( 'sample_database' , 'mstcompany' );  
                            $company        = getCompany_intoJSON($companyid);
                            $company_objectID    = $clsMongo->mongo_add_docment($company); 
                
                echo "<pre>";
                echo "<br> <span style='color:blue;'> Collection 'mstcompany' Selected. </span>";    
                echo "<br> CompanyID: $companyid Inserted.";                
                
                
                $company_objectid       = $company_objectID; 
                
                    
                echo "<br> Found ObjectID($company_objectid) of Company: $companyid.";                    
                
                
                $collection = $clsMongo->mongo_dbconnect( 'sample_database' , 'trncompanyprod' );  
                  
                echo "<br> <span style='color:blue;'> Collection 'trncompanyprod' Selected. </span>";   
                
                            $companyprod    = getCompanyProdData( $companyid , $company_objectid );
                            if(!empty($companyprod))
                            {
                                $trncompanyprod = $clsMongo->mongo_add_many_document( $companyprod );    
                            }
                            else
                            {
                                echo "<br> <span style='color:red;'> CompanyProd Data Not Found for Company: $companyid.</span>"; 
                            }
                            
                
                
                echo "<br> CompanyProd Data inserted for Company: $companyid."; 
            }
        
echo '<br> All Record/s inserted Successfully!';         

?>