<?php
class images_to_sprite {

	function __construct($folder,$output,$x,$y) {
		$this->folder = ($folder ? $folder : 'myfolder'); // Folder name to get images from, i.e. C:\\myfolder or /home/user/Desktop/folder
		$this->filetypes = array('jpg'=>true,'png'=>true,'jpeg'=>true,'gif'=>true); // Acceptable file extensions to consider
		$this->output = ($output ? $output : 'mysprite'); // Output filenames, mysprite.png and mysprite.css
		$this->x = $x; // Width of images to consider
		$this->y = $y; // Heigh of images to consider
		$this->files = array();
	}

	function create_sprite() {

		$basedir = $this->folder;
		$files = array();

		// Read through the directory for suitable images
		if($handle = opendir($this->folder)) {
			while (false !== ($file = readdir($handle))) {
				$split = explode('.',$file);
				// Ignore non-matching file extensions
				if($file[0] == '.' || !isset($this->filetypes[$split[count($split)-1]]))
					continue;
				// Get image size and ensure it has the correct dimensions
				$output = getimagesize($this->folder.'/'.$file);
				if($output[0] != $this->x && $output[1] != $this->y)
					continue;
				// Image will be added to sprite, add to array
				$this->files[$file] = $file;
			}
			closedir($handle);
		}

		// yy is the height of the sprite to be created, basically X * number of images
		$this->yy = $this->y * count($this->files);
		$im = imagecreatetruecolor($this->x,$this->yy);

		// Add alpha channel to image (transparency)
		imagesavealpha($im, true);
		$alpha = imagecolorallocatealpha($im, 0, 0, 0, 127);
		imagefill($im,0,0,$alpha);

		// Append images to sprite and generate CSS lines
		$i = $ii = 0;
		$fp = fopen($this->output.'.css','w');
		fwrite($fp,'.'.$this->output.' { width: '.$this->x.'px; height: '.$this->y.'px; background-image: url('.$this->output.'.png); text-align:center; }'."\n");
			foreach($this->files as $key => $file) {
			fwrite($fp,'.'.$this->output.(++$ii).' { background-position: -0px -'.($this->y*$i).'px; }'."\n");
			$im2 = imagecreatefrompng($this->folder.'/'.$file);
			imagecopy($im,$im2,0,($this->y*$i),0,0,$this->x,$this->y);
			$i++;
			}
		fclose($fp);
		imagepng($im,$this->output.'.png'); // Save image to file
		imagedestroy($im);
	}
}

$class = new images_to_sprite('imagefolder','sprite',63,63);
$class->create_sprite();
?>