<?php

  /************************************************************************
   * CSS and Javascript Combinator 0.5 + SMS gZip patch
   * Original Author 
   * http://rakaz.nl/item/make_your_pages_load_faster_by_combining_and_compressing_javascript_and_css_files
   * gZip patch by Sonassi Media Services (www.sonassi.com)
   */
 
  $cache    = true;
  $encoding = 'none';
  
	/*
	$cachedir = $_SERVER['DOCUMENT_ROOT']. 'cache';
	$cssdir   = $_SERVER['DOCUMENT_ROOT']. 'css';
	$jsdir    = $_SERVER['DOCUMENT_ROOT']. 'js';
	*/
	
	//$cachedir		= '/home/mumbaiye/public_html/common_code/cache';
	$cachedir		=  CACHE_DIR;
	$cssdir			= '/home/dubaiyel/public_html/common_code/css';
	$autosuggest	= '/home/dubaiyel/public_html/common_code/autosuggest';
	$jsdir			= '/home/dubaiyel/public_html/common_code/javascript';
	$jsautosuggest	= '/home/dubaiyel/public_html/common_code/autosuggest';
	$cssadmin		= '/home/dubaiyel/public_html/common_code/b2b/admin';
	$cssadminnew	= '/home/dubaiyel/public_html/common_code/b2b/newadmin';
	
	
	$allowed_encoding = array('none','gzip','deflate');
  
  //$js_library = '/data/lib/js'; # No trailing slash

  if(isset($_GET['encoding']) && in_array($_GET['encoding'],$allowed_encoding))
    $encoding = $_GET['encoding'];
 
  $type = $_GET['type'];
  // Determine the directory and type we should use
  switch ($_GET['type']) {
    case 'css':
      $base = realpath($cssdir);
      break;
    case 'javascript':
      $base = realpath($jsdir);
      break;
    case 'cssautosuggest':
	  $base = realpath($autosuggest);
	  $type = 'css';
	  break;
	case 'jsautosuggest':
	  $base = realpath($jsautosuggest);
	  $type = 'javascript';
	  break;
    case 'cssadmin':
	  $base = realpath($cssadmin);
	  $type = 'css';
	  break;
	case 'cssadminnew':
	  $base = realpath($cssadminnew);
	  $type = 'css';
	  break;  
    default:
      header ("HTTP/1.0 503 Not Implemented");
      exit;
  };
  
  
	$elements = explode(',', $_GET['files']);
   
  // Determine last modification date of the files
  $lastmodified = 0;
  while (list(,$element) = each($elements)) {
    if (strstr($element,'/lib/')) {
      $element = str_replace('/lib',$js_library,$element);
    } else {
      $element = $base . '/' . $element;
    }
    $path = realpath($element);
	if (($type == 'javascript' && substr($path, -3) != '.js') ||
      ($type == 'css' && substr($path, -4) != '.css' &&
      (substr($path, 0, strlen($base)) != $base || substr($path, 0, strlen($js_library)))
      )) {
      header ("HTTP/1.0 403 Forbidden");
      exit;
    }
	
    if (!file_exists($path)) {
      header ("HTTP/1.0 404 Not Found");
      exit;
    }
 
    $lastmodified = max($lastmodified, filemtime($path));
  }
  $longExpiryOffset = 604800; // 7 days
  // Send Etag hash
  $mhash = md5($_GET['files']);
  $hash = $lastmodified . '-' . $mhash;
  header ("Etag: \"" . $hash . "\"");
 
  if (isset($_SERVER['HTTP_IF_NONE_MATCH']) &&
    stripslashes($_SERVER['HTTP_IF_NONE_MATCH']) == '"' . $hash . '"')
  {
    // Return visit and no modifications, so do not send anything
    header ("HTTP/1.0 304 Not Modified");
    header ('Content-Length: 0');
  }
  else
  {
    // First time visit or files were modified
    if ($cache)
    {
      // Determine supported compression method
      $gzip = strstr($_SERVER['HTTP_ACCEPT_ENCODING'], 'gzip');
      $deflate = strstr($_SERVER['HTTP_ACCEPT_ENCODING'], 'deflate');
	  	
      // Determine used compression method
      if ($encoding != 'none')
        $encoding = $gzip ? 'gzip' : ($deflate ? 'deflate' : 'none');
	  
      // Check for buggy versions of Internet Explorer
      if (!strstr($_SERVER['HTTP_USER_AGENT'], 'Opera') && preg_match('/^Mozilla\/4\.0 \(compatible; MSIE ([0-9]\.[0-9])/i', $_SERVER['HTTP_USER_AGENT'], $matches)) {

        $version = floatval($matches[1]);
 
        if ($version < 6)
          $encoding = 'none';
 
        if ($version == 6 && !strstr($_SERVER['HTTP_USER_AGENT'], 'EV1'))
          $encoding = 'none';
      }
 
      // Try the cache first to see if the combined files were already generated
      $plaincachefile = 'cache-' . $hash . '.' . $type . '.combine-cache';
      $cachefile = $plaincachefile . ($encoding != 'none' ? '.' . $encoding : '');
 
      if (file_exists($cachedir . '/' . $cachefile)) {
 
        if ($encoding=='gzip') {
			header("HTTP/1.1 301 Moved Permanently");
          	header ( "Cache-Control: public, max-age=" . $longExpiryOffset );
			header ( "Expires: " . gmdate ( "D, d M Y H:i:s", time () + $longExpiryOffset ) . " GMT" );
			header("Location: /cache/$cachefile");
          header("Connection: close");
          exit;
        } else {
          header("HTTP/1.1 301 Moved Permanently");
          header ( "Cache-Control: public, max-age=" . $longExpiryOffset );
		  header ( "Expires: " . gmdate ( "D, d M Y H:i:s", time () + $longExpiryOffset ) . " GMT" );
          header("Location: /cache/$plaincachefile");
          header("Connection: close");
          exit;
        }
      }
    }
 
    // Get contents of the files
    $contents = '';
    reset($elements);
    while (list(,$element) = each($elements)) {
      if (strstr($element,'/lib/')) {
        $element = str_replace('/lib',$js_library,$element);
      } else {
        $element = $base . '/' . $element;
      }
 
      $path = realpath($element);
      $contents .= "\n\n" . file_get_contents($path);
	}
 
    // Send Content-Type
    header ("Content-Type: text/" . $type);
 
    // Store cache
    if ($cache) {
      if ($encoding != 'none') {
        $gcontents = gzencode("/*nGZIPPED $mhashn*/" . $contents, 9, $gzip ? FORCE_GZIP : FORCE_DEFLATE);
        if ($fp = fopen($cachedir . '/' . $cachefile, 'wb')) {
          fwrite($fp, $gcontents);
          fclose($fp);
		 exit();	
        }
      }
      if ($fp = fopen($cachedir . '/' . $plaincachefile, 'wb')) {
        fwrite($fp, $contents);
        fclose($fp);
        exit();
      }
      
	  foreach (glob($cachedir . "/" . "*" . $type .".combine-cache*") as $filename) {
        if (strstr($filename,$mhash) && !strstr($filename,$cachefile) && !strstr($filename,$plaincachefile))
          @unlink($filename);
      }
    }
	
	
    if ($encoding=='gzip') {
		header("HTTP/1.1 301 Moved Permanently");
		header("Location: cache/$cachefile");
		header("Connection: close");
      exit;
    } else {
		header("HTTP/1.1 301 Moved Permanently");
		header("Location: cache/$plaincachefile");
		header("Connection: close");
      exit;
    }
  } 
?>