<!DOCTYPE html>
<html lang="en">

<!-- Header Starts -->
<?php
require_once('includes/header.php');
?>
<!-- Header Ends -->

<section>
	<div class="mainwrapper">

		<!-- Left Bar Starts -->
		<?php
		require_once('includes/leftbar.php');
		?>
		<!-- Left Bar Ends -->

		<div class="mainpanel">
			<div class="pageheader">
				<div class="media">
					<div class="pageicon pull-left">
						<i class="fa fa-users" style="color:#FFF;"></i>
					</div>
					<div class="media-body">
						<ul class="breadcrumb">
							<li><a href=""><i class="glyphicon glyphicon-home"></i></a></li>
							<li>Member List</li>
						</ul>
						<h4>Member</h4>
					</div>
				</div><!-- media -->
			</div><!-- pageheader -->

			<div class="contentpanel">
				<div class="row">

					<?php
					if(isset($_GET['msg']))
					{
						if($_GET['msg'] == 2)
						{
							?>
							<div class="alert alert-success error_alert">
								<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
								Entry Edited Successfully.
							</div>
							<?php
						}
						else if($_GET['msg'] == 3)
						{
							?>
							<div class="alert alert-success  error_alert">
								<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
								Entry Inserted Successfully.
							</div>
							<?php
						}
						else if($_GET['msg'] == 4)
						{
							?>
							<div class="alert alert-success error_alert">
								<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
								Entry Deleted Successfully.
							</div>
							<?php
						}
					}
					?>

					<button class="btn btn-primary" onClick="location.href='member_add.php'">Create new Member</button>
					<?php
					$members_arr = $obj->select("*","mig_members","member_status = '1'");
					?>
					<table id="basicTable" class="table table-striped table-bordered responsive">
						<thead class="">
							<tr>
								<th>Sr No.</th>
								<th>Member Type</th>
								<th>Name</th>
								<th>Contact Details</th>
								<th>Nationality</th>
								<th>City</th>
								<th>State</th>
								<th>Pincode</th>
								<th>Options</th>
							</tr>
						</thead>
						<tbody>
							<?php

							if($members_arr != 0)
							{
								$i = 1;
								foreach($members_arr as $members)
								{
									?>
									<tr>
										<td><?php echo $i; ?></td>
										<td>
											<?php 
											if($members['member_type'] == '1')
											{
												echo 'PATRON MEMBERSHIP';
											}
											else if($members['member_type'] == '2')
											{
												echo 'LIFE MEMBERSHIP';
											}
											else if($members['member_type'] == '3')
											{
												echo 'ORDNINARY MEMBERSHIP';
											}
											?>
										</td>
										<td><?php echo $members['member_name']; ?></td>
										<td><?php echo 'Email : '.$members['member_email']; ?><br><?php echo 'Mobile : '.$members['member_mobile_no']; ?><br><?php echo 'Alt. Mobile : '.$members['member_alt_mobile_no']; ?></td>
										<td><?php echo $members['member_nationality']; ?></td>
										<td><?php echo $members['member_city']; ?></td>
										<td><?php echo $members['member_state']; ?></td>
										<td><?php echo $members['member_pincode']; ?></td>
										<td><a href="member_add.php?member_id=<?php echo base64_encode(base64_encode(base64_encode(base64_encode($members['member_id'])))); ?>"><i class="fa fa-pencil-square" title="Edit"></i></a> &nbsp; <a href="#" onclick="javascript :delete_record('<?php echo base64_encode(base64_encode(base64_encode(base64_encode($members['member_id'])))); ?>');"><i class="fa fa-trash-o" title="Delete"></i></a></td>
									</tr>
									<?php
									$i++;
								}
							}
							else
							{
								?>
								<tr>
									<td>No Records</td>
									<td></td>
									<td></td>
									<td></td>
									<td></td>
									<td></td>
									<td></td>
									<td></td>
									<td></td>
								</tr>
								<?php
							}
							?>
						</tbody>
					</table>
				</div><!-- row -->

			</div><!-- contentpanel -->

		</div><!-- mainpanel -->
	</div><!-- mainwrapper -->
</section>

<!-- Footer Starts -->
<?php
require_once('includes/footer.php');
?>
<!-- Footer Ends -->
<script src="js/jquery.dataTables.min.js"></script>
<script src="js/dataTables.bootstrap.js"></script>
<script src="js/dataTables.responsive.js"></script>
<script>
	function delete_record(member_id)
	{

		swal({
			title: "Delete",
			text: "Are you sure, you want to delete this record?",
			type: "warning",
			showCancelButton: true,
			confirmButtonColor: "#DD6B55",
			confirmButtonText: "Yes",
			closeOnConfirm: false
		},
		function(){

			var formdata= new FormData();
			formdata.append('member_id',member_id);
			formdata.append('type','delete');
			$.ajax({
				type:"post",
				data: formdata,
				processData: false,
				contentType: false,
				url:"member_add_action.php",
				beforeSend:function(){

				},
				success:function(res){
					res=res.trim();
						//alert(res);
						if(res == 'success')
						{
							swal("Deleted!", "Record is deleted Succesfully.", "success");

							swal({
								title: "Deleted!",
								text: "Record is deleted Succesfully.",
								type: "success"
							},
							function(){
								location.href="member_list.php";
							});
						}
						else
						{
							swal({
								title: "Remove Error!",
								text: "Something Went Wrong While Removing Info. Please Try Again.",
								type: "warning"
							},
							function(){
								location.href="member_list.php";
							});
						}

						
					}
				});
		});
	}

	jQuery(document).ready(function(){

		<?php
		if(isset($_GET['msg']))
		{
			?>
			setTimeout(function(){
				$(".error_alert").slideUp('fast');
				$(".error_alert").html('');
			}, 5000);
			<?php
		}
		?>

		jQuery('#basicTable').DataTable({
			responsive: true
		});

		var shTable = jQuery('#shTable').DataTable({
			"fnDrawCallback": function(oSettings) {
				jQuery('#shTable_paginate ul').addClass('pagination-active-dark');
			},
			responsive: true
		});

			// Show/Hide Columns Dropdown
			jQuery('#shCol').click(function(event){
				event.stopPropagation();
			});
			
			jQuery('#shCol input').on('click', function() {
				
				// Get the column API object
				var column = shTable.column($(this).val());
				
				// Toggle the visibility
				if ($(this).is(':checked'))
					column.visible(true);
				else
					column.visible(false);
			});
			
			var exRowTable = jQuery('#exRowTable').DataTable({
				responsive: true,
				"fnDrawCallback": function(oSettings) {
					jQuery('#exRowTable_paginate ul').addClass('pagination-active-success');
				},
				"ajax": "ajax/objects.txt",
				"columns": [
				{
					"class":          'details-control',
					"orderable":      false,
					"data":           null,
					"defaultContent": ''
				},
				{ "data": "name" },
				{ "data": "position" },
				{ "data": "office" },
				{ "data": "salary" }
				],
				"order": [[1, 'asc']] 
			});
			
			// Add event listener for opening and closing details
			jQuery('#exRowTable tbody').on('click', 'td.details-control', function () {
				var tr = $(this).closest('tr');
				var row = exRowTable.row( tr );
				
				if ( row.child.isShown() ) {
					// This row is already open - close it
					row.child.hide();
					tr.removeClass('shown');
				}
				else {
					// Open this row
					row.child( format(row.data()) ).show();
					tr.addClass('shown');
				}
			});
			
			
			// DataTables Length to Select2
			jQuery('div.dataTables_length select').removeClass('form-control input-sm');
			jQuery('div.dataTables_length select').css({width: '60px'});
			jQuery('div.dataTables_length select').select2({
				minimumResultsForSearch: -1
			});
			
		});

	function format (d) {
			// `d` is the original data object for the row
			return '<table class="table table-bordered nomargin">'+
			'<tr>'+
			'<td>Full name:</td>'+
			'<td>'+d.name+'</td>'+
			'</tr>'+
			'<tr>'+
			'<td>Extension number:</td>'+
			'<td>'+d.extn+'</td>'+
			'</tr>'+
			'<tr>'+
			'<td>Extra info:</td>'+
			'<td>And any further details here (images etc)...</td>'+
			'</tr>'+
			'</table>';
		}
	</script>
</body>
</html>
