<?php
require_once($_SERVER['DOCUMENT_ROOT'] . "/aipma2025/include/config.php");
require_once(INCLUDE_PATH . "startup.php");
$alltables = new AllTables();

     
if (!userchecklogin('', '', '', $G_memberuserid)) {
    $redirect = DOC_ROOT;
    header("location:" . $redirect);
    exit();      
}

$chapterLabels = [];
$worldData = []; 
$indiaData = [];


$chapterTitlenNames = array(
    '39' => 'All Plastic Finished Products',
    '56'=>'Wadding, felt and nonwovens; special yarns; twine, cordage, ropes and cables and articles thereof',
    '63' => 'Other made-up textile articles, Sacks, Bags, Tarpaulins',
    '85' => 'Electrical machinery and equipment and parts thereof',
    '87' => 'Vehicles other than railway or tramway rolling stock, and parts and accessories thereof',
    '90' => 'Optical, photographic, cinematographic, measuring, checking, precision, medical or surgical ',
    '94' => 'Furniture; bedding, mattresses, mattress supports, cushions and similar stuffed furnishings ',
    '95' => 'Toys, games and sports requisites; parts and accessories thereof',
    '96' => 'Miscellaneous manufactured articles',
);


if (isset($_REQUEST['to_country'])) 
{
    $to_country          = sanitize($_REQUEST['to_country'], SQL + HTML);
    $chaptercode          = intval($_REQUEST['chapeter_code']);
    
    $where = [];    
    empty($to_country)          ? null : $where['import_to_country'] = $to_country;
    empty($chaptercode)         ? null : $where['Chapter'] = $chaptercode;


    $i = 0;
    $wherecondition = '';
    $newwherecondition = '';
    $imagearray = array();

    foreach ($where as $key => $value) 
    {
        if ($i == 0) 
        {
            $i++;        
            $wherecondition .= " WHERE $key = '$value' ";
        } 
        else 
        {
            $wherecondition .= " AND $key = '$value' ";
        }
    }



    if ($to_country) {
        $searchText = " Import in $to_country,";
    }

   
    $searchText = rtrim($searchText, ', ');


    if ($wherecondition)                                                                           
    {
        // $searchsql = "SELECT * FROM " . CHAPTER_SUMMARY_VIEW . " $wherecondition ORDER BY chapter ASC";
        $searchsql = "SELECT * FROM import_totals_by_country_chapter_wise $wherecondition ORDER BY chapter ASC";
    }
    
    $searchdata = $alltables->getInfo("", $searchsql);
    $searchdatacount = count($searchdata);


    if ($searchdatacount) 
    {
        
        // $displayCountryName = ucfirst(strtolower($to_country));
        $displayCountryName = strtoupper($to_country);        // Table header
        
        
            if($to_country == 'CHINA')
            {
        
                $rowheader .= "
                    <tr>    
                        <th class='align-middle'>Sr. No.</th>
                        <th class='align-middle'>Chapter</th>
                        <th class='align-middle'>Product Label</th>
                        <th class='align-middle'>Country</th>
                        <th class='hsn-header-blue'>Import from World to ".$displayCountryName."</th>
                        <th class='hsn-header-blue'>Import from India to ". $displayCountryName."</th>
                        <th class='hsn-header-blue'>India's Share % in 2023 in ".$displayCountryName."</th>
                    </tr>";
            }
            else
            {
                
                $rowheader .= "
                <tr>    
                    <th class='align-middle'>Sr. No.</th>
                    <th class='align-middle'>Chapter</th>
                    <th class='align-middle'>Product Label</th>
                    <th class='align-middle'>Country</th>
                    <th class='hsn-header-blue'>Import from World to ".$displayCountryName."</th>
                    <th class='hsn-header-blue'>Import from India to ". $displayCountryName."</th>
                    <th class='hsn-header-blue'>India's Share % in 2023 in ".$displayCountryName."</th>
                    <th class='hsn-header-yellow'>China's Share % in 2023 in ".$displayCountryName."</th>
                    <th class='hsn-header-green'>Vietnam's Share % in 2023 in ".$displayCountryName."</th>
                </tr>";
            }
            
            // Arrays for Chart.js
            $hsnLabels = [];
            $worldData = [];
            $indiaData = [];
        
        
        $imagearray = getHsnCodeImage($chaptercode, $hsn_imagecode);
        
        for ($i = 0; $i < $searchdatacount; $i++) 
        {
            $chapter             = $searchdata[$i]["chapter"];
            $import_to_country   = $searchdata[$i]["import_to_country"];
            $import_from_world   = $searchdata[$i]["total_world_import"];
            $import_from_india   = $searchdata[$i]["total_india_import"];
            $import_from_china   = $searchdata[$i]["total_china_import"];
            $import_from_vietnam = $searchdata[$i]["total_vietnam_import"];
        
            // ✅ Skip if world import is zero                  
            if ($import_from_world <= 0) {
                continue;
            }
        
            if($to_country == 'CHINA')
            {
                // Calculate percentages
                $indiapercentage    = ($import_from_india / $import_from_world) * 100;
                $worldpercentage    = 100 - $indiapercentage;
            }
            else
            {
                
                 // Calculate percentages
                $indiapercentage    = ($import_from_india / $import_from_world) * 100;
                $chinapercentage    = ($import_from_china / $import_from_world) * 100;
                $vietnampercentage  = ($import_from_vietnam / $import_from_world) * 100;
            
                $sumpercentage      = $indiapercentage + $chinapercentage + $vietnampercentage;
                $worldpercentage    = 100 - $sumpercentage;
            }
        
          
        
            // ✅ Only add row if there’s some valid percentage
            if ($indiapercentage > 0 || $chinapercentage > 0 || $vietnampercentage > 0) 
            {
                
                 if($to_country == 'CHINA')
                {
                     $rows .= "<tr>                                                                                                                 
                        <td>".($i+1)."</td>                            
                        <td>$chapter</td>                     
                        <td>".$chapterTitlenNames[$chapter]."</td>
                        <td>$import_to_country</td>
                        <td class='hsn-header-blue'>".number_format($import_from_world, 0)."</td>
                        <td class='hsn-header-blue'>".number_format($import_from_india, 0)."</td>      
                        <td class='hsn-header-blue'>".round($indiapercentage, 2)."%</td>
                    </tr>";
                }
                else
                {
                
                
                    $rows .= "<tr>                                                                                                                 
                        <td>".($i+1)."</td>                            
                        <td>$chapter</td>                     
                        <td>".$chapterTitlenNames[$chapter]."</td>
                        <td>$import_to_country</td>
                        <td class='hsn-header-blue'>".number_format($import_from_world, 0)."</td>
                        <td class='hsn-header-blue'>".number_format($import_from_india, 0)."</td>      
                        <td class='hsn-header-blue'>".round($indiapercentage, 2)."%</td>
                        <td class='hsn-header-yellow'>".round($chinapercentage, 2)."%</td>
                        <td class='hsn-header-green'>".round($vietnampercentage, 2)."%</td>
                    </tr>";
                }
                // Push into arrays for Chart.js
                $chapterLabels[] = $chapter;                                                                   
                $worldData[]     = round($worldpercentage, 2);
                $indiaData[]     = round($indiapercentage, 2);
                $chinaData[]     = round($chinapercentage, 2);
                $vietnamData[]     = round($vietnampercentage, 2);
            }
        }


        // ✅ Output Chart.js script with JSON encoded arrays                                                              
        $javascriptCode = '
        <script>                  
            const chapterLabels = ' . json_encode($chapterLabels) . ';
            const worldPercentageData = ' . json_encode($worldData) . ';
            const indiaPercentageData = ' . json_encode($indiaData) . ';
        ';
    
    
        if ($to_country == 'CHINA') 
        {
        $javascriptCode .= '
        const chartInstance = new Chart(document.getElementById("Top25HSNCodelineChart"), {
            type: "line",             
            data: {
                labels: chapterLabels,
                datasets: [
                    {
                        label: "India Percentage",
                        data: indiaPercentageData,
                        borderColor: "rgba(255, 159, 64, 1)",      
                        backgroundColor: "rgba(255, 159, 64, 0.3)", 
                        fill: true,
                        tension: 0.3
                    }, 
                    {
                        label: "World Percentage",
                        data: worldPercentageData,
                        borderColor: "rgba(54, 162, 235, 1)",       
                        backgroundColor: "rgba(54, 162, 235, 0.3)", 
                        fill: true,
                        tension: 0.3
                    }
                ]
            },
            options: {
                responsive: true,
                plugins: {
                    title: {
                        display: true,
                        text: "India vs World Percentage by Chapter"
                    }
                },
                scales: {
                    x: { title: { display: true, text: "Chapter" } },
                    y: { title: { display: true, text: "Percentage" } }
                }
            }
        });
    
        // Hide World dataset by default
        chartInstance.setDatasetVisibility(1, false);
        chartInstance.update();
        '
        ;} 
        else 
        {
            // For other countries → India, China, Vietnam, World
            $javascriptCode .= '
            const chinaPercentageData = ' . json_encode($chinaData ?? []) . ';
            const vietnamPercentageData = ' . json_encode($vietnamData ?? []) . ';
        
            const chartInstance = new Chart(document.getElementById("Top25HSNCodelineChart"), {
                type: "line",             
                data: {
                    labels: chapterLabels,
                    datasets: [
                        {
                            label: "India Percentage",
                            data: indiaPercentageData,
                            borderColor: "rgba(255, 159, 64, 1)",      
                            backgroundColor: "rgba(255, 159, 64, 0.3)", 
                            fill: true,
                            tension: 0.3
                        }, 
                        {
                            label: "China Percentage",
                            data: chinaPercentageData,
                            borderColor: "rgba(255, 99, 132, 1)",       
                            backgroundColor: "rgba(255, 99, 132, 0.3)", 
                            fill: true,
                            tension: 0.3
                        }, 
                        {
                            label: "Vietnam Percentage",
                            data: vietnamPercentageData,
                            borderColor: "rgba(75, 192, 192, 1)",       
                            backgroundColor: "rgba(75, 192, 192, 0.3)", 
                            fill: true,
                            tension: 0.3
                        },
                        {
                            label: "World Percentage",
                            data: worldPercentageData,
                            borderColor: "rgba(54, 162, 235, 1)",       
                            backgroundColor: "rgba(54, 162, 235, 0.3)", 
                            fill: true,
                            tension: 0.3
                        }
                    ]
                },
                options: {
                    responsive: true,
                    plugins: {
                        title: {
                            display: true,
                            text: "Country-wise Share Percentage by Chapter"
                        }
                    },
                    scales: {
                        x: { title: { display: true, text: "Chapter" } },
                        y: { title: { display: true, text: "Percentage" } }
                    }
                }
            });
        
            // Hide World dataset by default
            chartInstance.setDatasetVisibility(3, false);
            chartInstance.update();';
        }


    $javascriptCode .= '</script>';

    
    }

}
                                     
                                     
                                     
                                     
                                  
                                     
                                     
                                     

require_once(REQUIRED_PATH . 'header.php');
require_once(VIEWS_PATH . "chapter-summary1.html");
require_once(REQUIRED_PATH . 'footer.php');

function getHsnCodeImage($chapter = '', $hsncode = '')
{  
    global $alltables;

    if ($chapter && $hsncode) {
        $wherecondition = "WHERE hscode = '$hsncode' && chapterno = '$chapter'";
    } else if ($chapter) {
        $wherecondition = " WHERE chapterno = '$chapter'";
    } else {
        $wherecondition = "WHERE hscode = '$hsncode'";
    }

    $sqlhsncodeimg = "SELECT chapterno,image FROM " . HSNCODE_IMAGE_TABLE . " $wherecondition LIMIT 0,4";


    $hsncodeImgData = $alltables->getInfo("", $sqlhsncodeimg);
    $hsncodeCount = count($hsncodeImgData);

    $base = DOC_ROOT . 'assets/img/hsn';

    if ($hsncodeCount) {
        for ($i = 0; $i < $hsncodeCount; $i++) {
            $chapterno = $hsncodeImgData[$i]['chapterno'];
            $imageval = $hsncodeImgData[$i]['image'];

            $imageurl =   $base . "/" . $chapterno . "/" . $imageval;

            $imagearray[$i] = $imageurl;
        }
    }

    return $imagearray;
}

function getToCountry($to_country = '')
{
    $alltables = new AllTables();
    $importtoptions = '';
    // $sqlimportto = "SELECT DISTINCT import_to_country FROM " .      MAIN_IMPORT_TABLE. " where import_to_country = 'USA'";  
    $sqlimportto = "SELECT DISTINCT import_to_country FROM " . MAIN_IMPORT_TABLE;
    $sqlimporttodata = $alltables->getInfo("", $sqlimportto);
    $sqlimporttodatacount = count($sqlimporttodata);

    if ($sqlimporttodatacount) {      
         $importtoptions .= "<option value='' hidden> Select Country</option>";
        for ($i = 0; $i < $sqlimporttodatacount; $i++) {
            $importto = $sqlimporttodata[$i]["import_to_country"];

            if ($importto == $to_country) {
                $importtoptions .= "<option value='" . $importto . "' selected>$importto</option>";
            } else {

                $importtoptions .= "<option value='" . $importto . "'>$importto</option>";
            }
        }
    }
    return $importtoptions;
}

